/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views.issues;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class CreationDateField
extends MarkerField {
    public String getValue(MarkerItem item) {
        if (item == null) {
            return null;
        }
        String time = item.getAttributeValue("creationdate", null);
        if (time == null) {
            return null;
        }
        Date date = new Date(Long.valueOf(time));
        Date now = new Date();
        long days = TimeUnit.MILLISECONDS.toDays(now.getTime() - date.getTime());
        if (days > 0L) {
            return CreationDateField.pluralize(days, "day", "days");
        }
        long hours = TimeUnit.MILLISECONDS.toHours(now.getTime() - date.getTime());
        if (hours > 0L) {
            return CreationDateField.pluralize(hours, "hour", "hours");
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(now.getTime() - date.getTime());
        if (minutes > 0L) {
            return CreationDateField.pluralize(minutes, "minute", "minutes");
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(now.getTime() - date.getTime());
        return CreationDateField.pluralize(Math.max(1L, seconds), "second", "seconds");
    }

    private static String pluralize(long strictlyPositiveCount, String singular, String plural) {
        if (strictlyPositiveCount == 1L) {
            return "1 " + singular + " ago";
        }
        return String.valueOf(strictlyPositiveCount) + " " + plural + " ago";
    }

    public int compare(MarkerItem item1, MarkerItem item2) {
        return Long.valueOf(item2.getAttributeValue("creationdate", "0")).compareTo(Long.valueOf(item1.getAttributeValue("creationdate", "0")));
    }

    public int getDefaultColumnWidth(Control control) {
        return 30 * CreationDateField.getFontWidth(control);
    }

    public static final int getFontWidth(Control control) {
        GC gc = new GC((Drawable)control.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return width;
    }
}

